package de.hrw.st.exam.tests;

import java.io.*;

public class TextAnalyser {

    /**
     * Counts occurence of a word in an input stream reader.
     * @param reader input stream reader
     * @param searchWord word that is searched
     * @return number of times word occurs
     * @throws IOException if an I/O problem occurs
     */
    public static long getWordCount(Reader reader, String searchWord) throws IOException {
        long wordCount = 0;
        try (BufferedReader br = new BufferedReader(reader)) {
            String line;
            while(null != (line = br.readLine())) {
                String[] wordsInLine = line.split("\\s+");
                for(String word : wordsInLine) {
                    if(word.equalsIgnoreCase(searchWord)) {
                        wordCount++;
                    }
                }
            }
        }
        return wordCount;
    }

}
