package de.hrw.st.exam.tests;

public class MathAnalyser {

    /**
     * Computes the digit sum (dt. Querysumme) auf a number.
     *
     * Examples:
     *   getDigitSum(9124) = 9 + 1 + 2 + 4 = 16
     *   getDigitSum(156) = 1 + 5 + 6 = 12
     *   getDigitSum(3) = 3
     *
     * @param n number to compute digit sum for
     * @return digit sum
     * @throws NullPointerException if n is null
     * @throws IllegalArgumentException if n is negative
     */
    public static long getDigitSum(Long n) throws IllegalArgumentException {
        if(n == null) {
            throw new NullPointerException("n must not be null");
        }
        if(n < 0) {
            throw new IllegalArgumentException("n must not be negative");
        }

        long remaining = n;
        long result = 0;
        while(remaining > 0) {
            result += remaining % 10;
            remaining /= 10;
        }
        return result;
    }

}
