package de.hrw.st.exam.patterns;

public class Book {

    /**
     * Title
     */
    private String title;

    /**
     * Author
     */
    private String author;

    /**
     * ISBN (international standard book number)
     */
    private String isbn;

    /**
     * Language
     */
    private Language language;

    /**
     * E-Book available
     */
    private Boolean eBookAvailable;

    /**
     * Default constructor.
     */
    public Book() {

    }

    /**
     * Constructor setting all fields.
     * @param title title
     * @param author author
     * @param isbn ISBN
     * @param language language
     * @param eBookAvailable true if and only if e-book is available for this book
     */
    public Book(String title, String author, String isbn, Language language, Boolean eBookAvailable) {
        this.title = title;
        this.author = author;
        this.isbn = isbn;
        this.language = language;
        this.eBookAvailable = eBookAvailable;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getIsbn() {
        return isbn;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    public Language getLanguage() {
        return language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public Boolean geteBookAvailable() {
        return eBookAvailable;
    }

    public void seteBookAvailable(Boolean eBookAvailable) {
        this.eBookAvailable = eBookAvailable;
    }
}
