#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "filesizecomputer.h"

#include <QMetaEnum>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    ui->menuBar->setNativeMenuBar(false);   // No native menu bar on Mac

    connect(ui->clearListButton, SIGNAL(clicked()), ui->fileList, SLOT(clearFiles()));
}

MainWindow::~MainWindow()
{
    delete ui;
}


void MainWindow::on_computeButton_clicked()
{
    // Compute all file sizes
    for(int i = 0; i < ui->fileList->urlCount(); i++) {
        QVariant size = computeFileSize(ui->fileList->url(i));
        ui->fileList->setItem(i, 1, new QTableWidgetItem(size.toString()));
    }

    ui->fileList->update();
}
