#ifndef FILEHASHTABLEWIDGET_H
#define FILEHASHTABLEWIDGET_H

#include <QTableWidget>

class FileSizeTableWidget : public QTableWidget
{
    Q_OBJECT

public:
    explicit FileSizeTableWidget(QWidget *parent = nullptr);
    ~FileSizeTableWidget();

    void dragEnterEvent(QDragEnterEvent *event);
    void dragMoveEvent(QDragMoveEvent *event);
    void dropEvent(QDropEvent *event);

    int urlCount() { return rowCount(); }
    QUrl url(int index);

public slots:
    void clearFiles();

private:
    QList<QUrl> m_urls;
};

#endif // FILEHASHTABLEWIDGET_H
