#include "filesizetablewidget.h"

#include <QDebug>
#include <QDragEnterEvent>
#include <QMimeData>
#include <QList>

FileSizeTableWidget::FileSizeTableWidget(QWidget *parent) : QTableWidget(parent)
{
    setAcceptDrops(true);

    setColumnCount(2);

    setHorizontalHeaderItem(0, new QTableWidgetItem("URL"));
    setHorizontalHeaderItem(1, new QTableWidgetItem("File size"));
}

FileSizeTableWidget::~FileSizeTableWidget()
{

}

void FileSizeTableWidget::dragEnterEvent(QDragEnterEvent *event)
{
    if (event->mimeData()->hasUrls()) {
        event->acceptProposedAction();
    }
}

void FileSizeTableWidget::dragMoveEvent(QDragMoveEvent *event)
{
    event->acceptProposedAction();
}

void FileSizeTableWidget::dropEvent(QDropEvent *event)
{
    QList<QUrl> urls = event->mimeData()->urls();

    for(QUrl url : urls) {
        if(url.toLocalFile().isEmpty()) {
            continue;
        }

        setRowCount(rowCount() + 1);

        setItem(rowCount() - 1, 0, new QTableWidgetItem(url.fileName()));
        setItem(rowCount() - 1, 1, new QTableWidgetItem(""));

        m_urls.append(url);
    }

    event->acceptProposedAction();
}

void FileSizeTableWidget::clearFiles() {
    while(rowCount() > 0) {
        removeRow(0);
    }
    m_urls.clear();
}

QUrl FileSizeTableWidget::url(int index) {
    return m_urls.at(index);
}
